/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.CoreUtils;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.MainFrame;
import com.gallery.GalleryRemote.MoveAlbumDialog;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.UploadPanel;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class AlbumInspector
extends JPanel
implements ActionListener,
ItemListener,
KeyListener,
PreferenceNames {
    public static final String MODULE = "AlbmInspec";
    JLabel jLabelName = new JLabel();
    JLabel jLabelTitle = new JLabel();
    JPanel jSpacer = new JPanel();
    JLabel jLabelPictures = new JLabel();
    JLabel jLabelSummary = new JLabel();
    JPanel jOverridePanel = new JPanel();
    JPanel jPanelProps = new JPanel();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JTextArea jTitle = new JTextArea();
    JTextArea jPictures = new JTextArea();
    JTextArea jName = new JTextArea();
    JTextArea jSummary = new JTextArea();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton jFetch = new JButton();
    JButton jSlideshow = new JButton();
    JButton jNew = new JButton();
    JLabel jApply = new JLabel();
    JButton jMove = new JButton();
    JCheckBox jResizeBeforeUpload = new JCheckBox();
    JRadioButton jResizeToDefault = new JRadioButton();
    JRadioButton jResizeToForce = new JRadioButton();
    JComboBox jResizeTo = new JComboBox(UploadPanel.defaultSizes);
    JCheckBox jBeginning = new JCheckBox();
    MainFrame mf = null;
    Album album = null;
    boolean ignoreItemChanges = false;
    boolean ignoreNextComboBoxChanged = false;
    public Action nextFocusAction = new AbstractAction("Move Focus Forwards"){

        public void actionPerformed(ActionEvent evt) {
            ((Component)evt.getSource()).transferFocus();
        }
    };
    public Action prevFocusAction = new AbstractAction("Move Focus Backwards"){

        public void actionPerformed(ActionEvent evt) {
            ((Component)evt.getSource()).transferFocusBackward();
        }
    };
    public Action nextPictureAction = new AbstractAction("Select Next Picture"){

        public void actionPerformed(ActionEvent evt) {
            CoreUtils.selectNextPicture();
        }
    };
    public Action prevPictureAction = new AbstractAction("Select Prev Picture"){

        public void actionPerformed(ActionEvent evt) {
            CoreUtils.selectPrevPicture();
        }
    };

    public AlbumInspector() {
        this.jbInit();
        this.jbInitEvents();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.jLabelName.setText(GRI18n.getString((String)MODULE, (String)"Name"));
        this.jLabelTitle.setText(GRI18n.getString((String)MODULE, (String)"Title"));
        this.jLabelPictures.setText(GRI18n.getString((String)MODULE, (String)"Pictures"));
        this.jLabelSummary.setText(GRI18n.getString((String)MODULE, (String)"Summary"));
        this.jName.setFont(UIManager.getFont("Label.font"));
        this.jName.setLineWrap(true);
        this.jTitle.setFont(UIManager.getFont("Label.font"));
        this.jTitle.setLineWrap(true);
        this.jSummary.setFont(UIManager.getFont("Label.font"));
        this.jSummary.setLineWrap(true);
        this.jPictures.setFont(UIManager.getFont("Label.font"));
        this.jPictures.setEditable(false);
        this.jPictures.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jOverridePanel.setLayout(new GridBagLayout());
        this.jPanelProps.setLayout(new GridBagLayout());
        this.jSlideshow.setText(GRI18n.getString((String)MODULE, (String)"Slideshow"));
        this.jFetch.setText(GRI18n.getString((String)MODULE, (String)"Fetch"));
        this.jNew.setText(GRI18n.getString((String)MODULE, (String)"New"));
        this.jApply.setText(GRI18n.getString((String)MODULE, (String)"Apply"));
        this.jMove.setText(GRI18n.getString((String)MODULE, (String)"Move"));
        this.jResizeTo.setToolTipText(GRI18n.getString((String)MODULE, (String)"res2W"));
        this.jResizeTo.setEditable(true);
        this.jResizeTo.setRenderer(new UploadPanel.SizeListRenderer());
        this.jResizeBeforeUpload.setToolTipText(GRI18n.getString((String)MODULE, (String)"resBfrUpldTip"));
        this.jResizeBeforeUpload.setText(GRI18n.getString((String)MODULE, (String)"resBfrUpld"));
        this.jResizeToDefault.setToolTipText(GRI18n.getString((String)MODULE, (String)"res2Def"));
        this.jResizeToDefault.setText(GRI18n.getString((String)MODULE, (String)"res2Def"));
        this.jResizeToForce.setToolTipText(GRI18n.getString((String)MODULE, (String)"res2FrcTip"));
        this.jResizeToForce.setText(GRI18n.getString((String)MODULE, (String)"res2Frc"));
        this.jBeginning.setText(GRI18n.getString((String)MODULE, (String)"Beginning"));
        this.jOverridePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString((String)MODULE, (String)"Override")));
        this.jPanelProps.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString((String)MODULE, (String)"Props")));
        this.jPanelProps.add((Component)this.jLabelName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 0, 0, 5), 2, 0));
        this.jPanelProps.add((Component)new JScrollPane(this.jName), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.jPanelProps.add((Component)this.jLabelTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 0, 0, 5), 2, 0));
        this.jPanelProps.add((Component)new JScrollPane(this.jTitle), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.jPanelProps.add((Component)this.jLabelSummary, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 0, 0, 5), 0, 0));
        this.jPanelProps.add((Component)new JScrollPane(this.jSummary), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelProps.add((Component)this.jLabelPictures, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 2, 5), 2, 0));
        this.jPanelProps.add((Component)this.jPictures, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.jPanelProps.add((Component)this.jApply, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.jPanelProps.add((Component)this.jMove, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.jOverridePanel.add((Component)this.jResizeBeforeUpload, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jOverridePanel.add((Component)this.jResizeToDefault, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.jOverridePanel.add((Component)this.jResizeToForce, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.jOverridePanel.add((Component)this.jResizeTo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jOverridePanel.add((Component)this.jBeginning, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanelProps, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jOverridePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jFetch, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jSlideshow, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jSpacer, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonGroup1.add(this.jResizeToDefault);
        this.buttonGroup1.add(this.jResizeToForce);
        this.setMinimumSize(new Dimension(150, 0));
        this.setupKeyboardHandling(this.jName);
        this.setupKeyboardHandling(this.jTitle);
        this.setupKeyboardHandling(this.jSummary);
    }

    private void setupKeyboardHandling(JComponent c) {
        c.getInputMap().put(KeyStroke.getKeyStroke(9, 0), this.nextFocusAction.getValue("Name"));
        c.getInputMap().put(KeyStroke.getKeyStroke(9, 1), this.prevFocusAction.getValue("Name"));
        c.getInputMap().put(KeyStroke.getKeyStroke(40, 0), this.nextPictureAction.getValue("Name"));
        c.getInputMap().put(KeyStroke.getKeyStroke(38, 0), this.prevPictureAction.getValue("Name"));
        c.getActionMap().put(this.nextFocusAction.getValue("Name"), this.nextFocusAction);
        c.getActionMap().put(this.prevFocusAction.getValue("Name"), this.prevFocusAction);
        c.getActionMap().put(this.nextPictureAction.getValue("Name"), this.nextPictureAction);
        c.getActionMap().put(this.prevPictureAction.getValue("Name"), this.prevPictureAction);
    }

    private void jbInitEvents() {
        this.jFetch.addActionListener(this);
        this.jSlideshow.addActionListener(this);
        this.jNew.addActionListener(this);
        this.jMove.addActionListener(this);
        this.jBeginning.addItemListener(this);
        this.jResizeBeforeUpload.addItemListener(this);
        this.jResizeToDefault.addItemListener(this);
        this.jResizeToForce.addItemListener(this);
        this.jResizeTo.addActionListener(this);
        this.jResizeTo.getEditor().getEditorComponent().addKeyListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.ignoreItemChanges) {
            return;
        }
        String command = e.getActionCommand();
        JComponent source = (JComponent)e.getSource();
        Log.log((int)3, (String)MODULE, (String)("Action selected " + command));
        if (source == this.jFetch) {
            this.mf.fetchAlbumImages();
        } else if (source == this.jNew) {
            this.mf.newAlbum();
        } else if (source != this.jApply) {
            if (source == this.jMove) {
                MoveAlbumDialog mad = new MoveAlbumDialog((Frame)this.mf, this.album.getGallery(), this.album);
                Album newParent = mad.getNewParent();
                if (newParent != null) {
                    this.album.moveAlbumTo(GalleryRemote._().getCore().getMainStatusUpdate(), newParent);
                    this.album.getGallery().reload();
                }
            } else if (source == this.jSlideshow) {
                this.mf.slideshow();
            } else if (source == this.jResizeTo) {
                if ("comboBoxChanged".equals(command)) {
                    if (this.ignoreNextComboBoxChanged) {
                        this.ignoreNextComboBoxChanged = false;
                    } else {
                        this.readResizeTo(this.jResizeTo.getSelectedItem().toString());
                    }
                }
            } else {
                Log.log((int)3, (String)MODULE, (String)("Unknown source " + source));
            }
        }
    }

    private void readResizeTo(String text) {
        if (this.ignoreItemChanges) {
            return;
        }
        try {
            int overrideDimension = this.album.getOverrideResizeDimension();
            int newOverrideDimension = Integer.parseInt(text);
            if (overrideDimension != -1 || newOverrideDimension != GalleryRemote._().properties.getIntDimensionProperty("resizeTo")) {
                Log.log((int)3, (String)MODULE, (String)("Overriding dimension to " + newOverrideDimension));
                this.album.setOverrideResizeDimension(newOverrideDimension);
            }
        }
        catch (NumberFormatException ee) {
            Log.logException((int)1, (String)MODULE, (Throwable)ee);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.ignoreItemChanges) {
            return;
        }
        JComponent source = (JComponent)e.getSource();
        Log.log((int)3, (String)MODULE, (String)("Item state changed " + source));
        if (source == this.jBeginning) {
            this.album.setOverrideAddToBeginning(new Boolean(this.jBeginning.isSelected()));
        } else if (source == this.jResizeBeforeUpload) {
            this.album.setOverrideResize(new Boolean(this.jResizeBeforeUpload.isSelected()));
            this.resetUIState();
        } else if (source == this.jResizeToDefault || source == this.jResizeToForce) {
            this.album.setOverrideResizeDefault(new Boolean(this.jResizeToDefault.isSelected()));
            this.resetUIState();
        } else {
            Log.log((int)3, (String)MODULE, (String)("Unknown source " + source));
        }
        this.ignoreNextComboBoxChanged = false;
    }

    public void resetUIState() {
        boolean oldIgnoreItemChanges = this.ignoreItemChanges;
        this.ignoreItemChanges = true;
        if (this.album != null && this.jResizeBeforeUpload.isSelected()) {
            this.jResizeToDefault.setEnabled(true);
            this.jResizeToForce.setEnabled(true);
            if (this.jResizeToForce.isSelected()) {
                this.jResizeTo.setEnabled(true);
                this.jResizeTo.setBackground(UIManager.getColor("TextField.background"));
            } else {
                this.jResizeTo.setEnabled(false);
                this.jResizeTo.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            }
        } else {
            this.jResizeToDefault.setEnabled(false);
            this.jResizeToForce.setEnabled(false);
            this.jResizeTo.setEnabled(false);
            this.jResizeTo.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
        this.ignoreItemChanges = oldIgnoreItemChanges;
    }

    public void setMainFrame(MainFrame mf) {
        this.mf = mf;
    }

    public void setAlbum(Album album) {
        boolean oldIgnoreItemChanges = this.ignoreItemChanges;
        this.ignoreItemChanges = true;
        this.album = album;
        if (album == null) {
            this.jName.setText("");
            this.jTitle.setText("");
            this.jSummary.setText("");
            this.jPictures.setText("");
            this.setEnabledInternal(false);
        } else {
            this.setEnabledInternal(true);
            this.jName.setText(album.getName());
            this.jTitle.setText(album.getTitle());
            this.jSummary.setText(album.getSummary());
            this.jPictures.setText("" + album.getSize());
            this.jResizeBeforeUpload.setSelected(album.getResize());
            this.jResizeToDefault.setSelected(album.getResizeDefault());
            this.jResizeToForce.setSelected(!album.getResizeDefault());
            UploadPanel.setupComboValue(album.getResizeDimension(), this.jResizeTo);
            this.ignoreNextComboBoxChanged = true;
            this.jBeginning.setSelected(album.getAddToBeginning());
            this.jFetch.setEnabled(album.getGallery().getComm((StatusUpdate)this.mf.jStatusBar).hasCapability((StatusUpdate)this.mf.jStatusBar, 9));
            this.jMove.setEnabled(album.getGallery().getComm((StatusUpdate)this.mf.jStatusBar).hasCapability((StatusUpdate)this.mf.jStatusBar, 10));
            this.jSlideshow.setEnabled(album.getSize() > 0);
        }
        this.jApply.setEnabled(false);
        this.jName.setEditable(false);
        this.jName.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jTitle.setEditable(false);
        this.jTitle.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jSummary.setEditable(false);
        this.jSummary.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jPictures.setEditable(false);
        this.jPictures.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.resetUIState();
        this.ignoreItemChanges = oldIgnoreItemChanges;
    }

    public void setEnabledInternal(boolean enabled) {
        this.jName.setEnabled(enabled);
        this.jTitle.setEnabled(enabled);
        this.jSummary.setEnabled(enabled);
        this.jPictures.setEnabled(enabled);
        this.jFetch.setEnabled(enabled);
        this.jSlideshow.setEnabled(enabled);
        this.jNew.setEnabled(enabled);
        this.jApply.setEnabled(enabled);
        this.jMove.setEnabled(enabled);
        this.jResizeBeforeUpload.setEnabled(enabled);
        this.jResizeToDefault.setEnabled(enabled);
        this.jResizeToForce.setEnabled(enabled);
        this.jResizeTo.setEnabled(enabled);
        this.jBeginning.setEnabled(enabled);
        if (enabled) {
            this.jResizeTo.setBackground(UIManager.getColor("TextField.background"));
        } else {
            this.jResizeTo.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
    }

    public void setEnabled(boolean enabled) {
        this.setEnabledInternal(enabled);
        super.setEnabled(enabled);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.readResizeTo(this.jResizeTo.getEditor().getItem().toString());
    }

    public void keyTyped(KeyEvent e) {
    }
}

