/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.gallery.GalleryRemote.GalleryFileFilter;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.model.ExifData;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ExifImageUtils {
    public static final String MODULE = "ExifUtils";
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;
    static /* synthetic */ Class class$com$drew$metadata$iptc$IptcDirectory;

    public static ExifData getExifData(String filename) {
        if (GalleryFileFilter.canManipulateJpeg(filename)) {
            File jpegFile = new File(filename);
            try {
                Metadata metadata = JpegMetadataReader.readMetadata(jpegFile);
                Directory exifDirectory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifImageUtils.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
                Directory iptcDirectory = metadata.getDirectory(class$com$drew$metadata$iptc$IptcDirectory == null ? (class$com$drew$metadata$iptc$IptcDirectory = ExifImageUtils.class$("com.drew.metadata.iptc.IptcDirectory")) : class$com$drew$metadata$iptc$IptcDirectory);
                ExifData exif = new ExifData();
                exif.setCaption(ExifImageUtils.getCaption(exifDirectory, iptcDirectory, filename));
                exif.setTargetOrientation(ExifImageUtils.getTargetOrientation(exifDirectory, iptcDirectory, filename));
                exif.setCreationDate(ExifImageUtils.getCreationDate(exifDirectory, iptcDirectory, filename));
                return exif;
            }
            catch (FileNotFoundException e) {
                Log.logException(1, MODULE, e);
                return null;
            }
            catch (JpegProcessingException e) {
                Log.logException(1, MODULE, e);
                return null;
            }
        }
        return null;
    }

    public static Date getCreationDate(Directory exifDirectory, Directory iptcDirectory, String filename) {
        String exifDateCreated = exifDirectory.getString(36867);
        if (exifDateCreated == null) {
            Log.log(3, MODULE, "Picture " + filename + " has no EXIF Date Created");
            return null;
        }
        Log.log(3, MODULE, "Picture " + filename + " has EXIF Date Created of " + exifDateCreated);
        try {
            return sdf.parse(exifDateCreated);
        }
        catch (ParseException e) {
            Log.logException(1, MODULE, e);
            return null;
        }
    }

    public static String getCaption(Directory exifDirectory, Directory iptcDirectory, String filename) {
        String caption = exifDirectory.getString(270);
        if (caption != null && caption.length() != 0) {
            Log.log(3, MODULE, "Picture " + filename + " TAG_IMAGE_DESCRIPTION: " + caption);
            return caption.trim();
        }
        caption = exifDirectory.getString(37510);
        if (caption != null && caption.length() != 0) {
            Log.log(3, MODULE, "Picture " + filename + " TAG_USER_COMMENT: " + caption);
            return caption.trim();
        }
        caption = iptcDirectory.getString(632);
        if (caption != null && caption.length() != 0) {
            Log.log(3, MODULE, "Picture " + filename + " IPTC DESCRIPTION: " + caption);
            return caption.trim();
        }
        Log.log(3, MODULE, "Picture " + filename + " has no usable EXIF or IPTC info");
        return null;
    }

    public static ImageUtils.AngleFlip getTargetOrientation(Directory exifDirectory, Directory iptcDirectory, String filename) {
        String orientation = exifDirectory.getString(274);
        if (orientation == null) {
            Log.log(3, MODULE, "Picture " + filename + " has no EXIF ORIENTATION tag");
            return null;
        }
        Log.log(3, MODULE, "Picture " + filename + " EXIF ORIENTATION: " + orientation);
        int or = 0;
        ImageUtils.AngleFlip af = null;
        try {
            or = Integer.parseInt(orientation);
        }
        catch (NumberFormatException e) {
            Log.log(1, MODULE, "Couldn't parse orientation " + orientation + " for " + filename);
            return null;
        }
        switch (or) {
            case 1: {
                af = new ImageUtils.AngleFlip(0, false);
                break;
            }
            case 2: {
                af = new ImageUtils.AngleFlip(0, true);
                break;
            }
            case 3: {
                af = new ImageUtils.AngleFlip(2, false);
                break;
            }
            case 4: {
                af = new ImageUtils.AngleFlip(2, true);
                break;
            }
            case 5: {
                af = new ImageUtils.AngleFlip(1, true);
                break;
            }
            case 6: {
                af = new ImageUtils.AngleFlip(1, false);
                break;
            }
            case 7: {
                af = new ImageUtils.AngleFlip(3, true);
                break;
            }
            case 8: {
                af = new ImageUtils.AngleFlip(3, false);
                break;
            }
            default: {
                Log.log(1, MODULE, "Couldn't parse orientation " + orientation + " for " + filename);
                return null;
            }
        }
        return af;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

